#ifndef CUFFTDX_FFT_32_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_32_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<234, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<612>;
.reg .b64 rd<2>;
add.f32 f129, %64, %106;
add.f32 f130, %65, %108;
sub.f32 f131, %64, %106;
sub.f32 f132, %65, %108;
add.f32 f133, %85, %128;
add.f32 f134, %87, %129;
sub.f32 f135, %85, %128;
sub.f32 f136, %87, %129;
add.f32 f137, f129, f133;
add.f32 f138, f130, f134;
sub.f32 f139, f129, f133;
sub.f32 f140, f130, f134;
sub.f32 f141, f131, f136;
add.f32 f142, f132, f135;
add.f32 f143, f131, f136;
sub.f32 f144, f132, f135;
add.f32 f145, %74, %117;
add.f32 f146, %76, %119;
sub.f32 f147, %74, %117;
sub.f32 f148, %76, %119;
add.f32 f149, %96, %138;
add.f32 f150, %97, %140;
sub.f32 f151, %96, %138;
sub.f32 f152, %97, %140;
add.f32 f153, f145, f149;
add.f32 f154, f146, f150;
sub.f32 f155, f145, f149;
sub.f32 f156, f146, f150;
sub.f32 f157, f147, f152;
add.f32 f158, f148, f151;
add.f32 f159, f147, f152;
sub.f32 f160, f148, f151;
mul.f32 f161, f157, 0f3F3504F3;
mul.f32 f162, f158, 0f3F3504F3;
sub.f32 f163, f161, f162;
add.f32 f164, f161, f162;
mul.f32 f165, f159, 0fBF3504F3;
mul.f32 f166, f160, 0f3F3504F3;
sub.f32 f167, f165, f166;
mul.f32 f168, f160, 0fBF3504F3;
fma.rn.f32 f169, f159, 0f3F3504F3, f168;
add.f32 f170, f137, f153;
add.f32 f171, f138, f154;
sub.f32 f172, f137, f153;
sub.f32 f173, f138, f154;
add.f32 f174, f141, f163;
add.f32 f175, f142, f164;
sub.f32 f176, f141, f163;
sub.f32 f177, f142, f164;
sub.f32 f178, f139, f156;
add.f32 f179, f140, f155;
add.f32 f180, f139, f156;
sub.f32 f181, f140, f155;
add.f32 f182, f143, f167;
add.f32 f183, f144, f169;
sub.f32 f184, f143, f167;
sub.f32 f185, f144, f169;
add.f32 f186, %69, %112;
add.f32 f187, %71, %113;
sub.f32 f188, %69, %112;
sub.f32 f189, %71, %113;
add.f32 f190, %90, %133;
add.f32 f191, %92, %135;
sub.f32 f192, %90, %133;
sub.f32 f193, %92, %135;
add.f32 f194, f186, f190;
add.f32 f195, f187, f191;
sub.f32 f196, f186, f190;
sub.f32 f197, f187, f191;
sub.f32 f198, f188, f193;
add.f32 f199, f189, f192;
add.f32 f200, f188, f193;
sub.f32 f201, f189, f192;
add.f32 f202, %80, %122;
add.f32 f203, %81, %124;
sub.f32 f204, %80, %122;
sub.f32 f205, %81, %124;
add.f32 f206, %101, %144;
add.f32 f207, %103, %145;
sub.f32 f208, %101, %144;
sub.f32 f209, %103, %145;
add.f32 f210, f202, f206;
add.f32 f211, f203, f207;
sub.f32 f212, f202, f206;
sub.f32 f213, f203, f207;
sub.f32 f214, f204, f209;
add.f32 f215, f205, f208;
add.f32 f216, f204, f209;
sub.f32 f217, f205, f208;
mul.f32 f218, f214, 0f3F3504F3;
mul.f32 f219, f215, 0f3F3504F3;
sub.f32 f220, f218, f219;
add.f32 f221, f218, f219;
mul.f32 f222, f216, 0fBF3504F3;
mul.f32 f223, f217, 0f3F3504F3;
sub.f32 f224, f222, f223;
mul.f32 f225, f217, 0fBF3504F3;
fma.rn.f32 f226, f216, 0f3F3504F3, f225;
add.f32 f227, f194, f210;
add.f32 f228, f195, f211;
sub.f32 f229, f194, f210;
sub.f32 f230, f195, f211;
add.f32 f231, f198, f220;
add.f32 f232, f199, f221;
sub.f32 f233, f198, f220;
sub.f32 f234, f199, f221;
sub.f32 f235, f196, f213;
add.f32 f236, f197, f212;
add.f32 f237, f196, f213;
sub.f32 f238, f197, f212;
add.f32 f239, f200, f224;
add.f32 f240, f201, f226;
sub.f32 f241, f200, f224;
sub.f32 f242, f201, f226;
mul.f32 f243, f231, 0f3F6C835E;
mul.f32 f244, f232, 0f3EC3EF15;
sub.f32 f245, f243, f244;
mul.f32 f246, f232, 0f3F6C835E;
fma.rn.f32 f247, f231, 0f3EC3EF15, f246;
mul.f32 f248, f235, 0f3F3504F3;
mul.f32 f249, f236, 0f3F3504F3;
sub.f32 f250, f248, f249;
add.f32 f251, f248, f249;
mul.f32 f252, f239, 0f3EC3EF15;
mul.f32 f253, f240, 0f3F6C835E;
sub.f32 f254, f252, f253;
mul.f32 f255, f240, 0f3EC3EF15;
fma.rn.f32 f256, f239, 0f3F6C835E, f255;
mul.f32 f257, f233, 0fBEC3EF15;
mul.f32 f258, f234, 0f3F6C835E;
sub.f32 f259, f257, f258;
mul.f32 f260, f234, 0fBEC3EF15;
fma.rn.f32 f261, f233, 0f3F6C835E, f260;
mul.f32 f262, f237, 0fBF3504F3;
mul.f32 f263, f238, 0f3F3504F3;
sub.f32 f264, f262, f263;
mul.f32 f265, f238, 0fBF3504F3;
fma.rn.f32 f266, f237, 0f3F3504F3, f265;
mul.f32 f267, f241, 0fBF6C835E;
mul.f32 f268, f242, 0f3EC3EF15;
sub.f32 f269, f267, f268;
mul.f32 f270, f242, 0fBF6C835E;
fma.rn.f32 f271, f241, 0f3EC3EF15, f270;
add.f32 f272, f170, f227;
add.f32 f273, f171, f228;
sub.f32 f274, f170, f227;
sub.f32 f275, f171, f228;
add.f32 f276, f174, f245;
add.f32 f277, f175, f247;
sub.f32 f278, f174, f245;
sub.f32 f279, f175, f247;
add.f32 f280, f178, f250;
add.f32 f281, f179, f251;
sub.f32 f282, f178, f250;
sub.f32 f283, f179, f251;
add.f32 f284, f182, f254;
add.f32 f285, f183, f256;
sub.f32 f286, f182, f254;
sub.f32 f287, f183, f256;
sub.f32 f288, f172, f230;
add.f32 f289, f173, f229;
add.f32 f290, f172, f230;
sub.f32 f291, f173, f229;
add.f32 f292, f176, f259;
add.f32 f293, f177, f261;
sub.f32 f294, f176, f259;
sub.f32 f295, f177, f261;
add.f32 f296, f180, f264;
add.f32 f297, f181, f266;
sub.f32 f298, f180, f264;
sub.f32 f299, f181, f266;
add.f32 f300, f184, f269;
add.f32 f301, f185, f271;
sub.f32 f302, f184, f269;
sub.f32 f303, f185, f271;
add.f32 f304, %66, %109;
add.f32 f305, %68, %111;
sub.f32 f306, %66, %109;
sub.f32 f307, %68, %111;
add.f32 f308, %88, %130;
add.f32 f309, %89, %132;
sub.f32 f310, %88, %130;
sub.f32 f311, %89, %132;
add.f32 f312, f304, f308;
add.f32 f313, f305, f309;
sub.f32 f314, f304, f308;
sub.f32 f315, f305, f309;
sub.f32 f316, f306, f311;
add.f32 f317, f307, f310;
add.f32 f318, f306, f311;
sub.f32 f319, f307, f310;
add.f32 f320, %77, %120;
add.f32 f321, %79, %121;
sub.f32 f322, %77, %120;
sub.f32 f323, %79, %121;
add.f32 f324, %98, %141;
add.f32 f325, %100, %143;
sub.f32 f326, %98, %141;
sub.f32 f327, %100, %143;
add.f32 f328, f320, f324;
add.f32 f329, f321, f325;
sub.f32 f330, f320, f324;
sub.f32 f331, f321, f325;
sub.f32 f332, f322, f327;
add.f32 f333, f323, f326;
add.f32 f334, f322, f327;
sub.f32 f335, f323, f326;
mul.f32 f336, f332, 0f3F3504F3;
mul.f32 f337, f333, 0f3F3504F3;
sub.f32 f338, f336, f337;
add.f32 f339, f336, f337;
mul.f32 f340, f334, 0fBF3504F3;
mul.f32 f341, f335, 0f3F3504F3;
sub.f32 f342, f340, f341;
mul.f32 f343, f335, 0fBF3504F3;
fma.rn.f32 f344, f334, 0f3F3504F3, f343;
add.f32 f345, f312, f328;
add.f32 f346, f313, f329;
sub.f32 f347, f312, f328;
sub.f32 f348, f313, f329;
add.f32 f349, f316, f338;
add.f32 f350, f317, f339;
sub.f32 f351, f316, f338;
sub.f32 f352, f317, f339;
sub.f32 f353, f314, f331;
add.f32 f354, f315, f330;
add.f32 f355, f314, f331;
sub.f32 f356, f315, f330;
add.f32 f357, f318, f342;
add.f32 f358, f319, f344;
sub.f32 f359, f318, f342;
sub.f32 f360, f319, f344;
add.f32 f361, %72, %114;
add.f32 f362, %73, %116;
sub.f32 f363, %72, %114;
sub.f32 f364, %73, %116;
add.f32 f365, %93, %136;
add.f32 f366, %95, %137;
sub.f32 f367, %93, %136;
sub.f32 f368, %95, %137;
add.f32 f369, f361, f365;
add.f32 f370, f362, f366;
sub.f32 f371, f361, f365;
sub.f32 f372, f362, f366;
sub.f32 f373, f363, f368;
add.f32 f374, f364, f367;
add.f32 f375, f363, f368;
sub.f32 f376, f364, f367;
add.f32 f377, %82, %125;
add.f32 f378, %84, %127;
sub.f32 f379, %82, %125;
sub.f32 f380, %84, %127;
add.f32 f381, %104, %146;
add.f32 f382, %105, %147;
sub.f32 f383, %104, %146;
sub.f32 f384, %105, %147;
add.f32 f385, f377, f381;
add.f32 f386, f378, f382;
sub.f32 f387, f377, f381;
sub.f32 f388, f378, f382;
sub.f32 f389, f379, f384;
add.f32 f390, f380, f383;
add.f32 f391, f379, f384;
sub.f32 f392, f380, f383;
mul.f32 f393, f389, 0f3F3504F3;
mul.f32 f394, f390, 0f3F3504F3;
sub.f32 f395, f393, f394;
add.f32 f396, f393, f394;
mul.f32 f397, f391, 0fBF3504F3;
mul.f32 f398, f392, 0f3F3504F3;
sub.f32 f399, f397, f398;
mul.f32 f400, f392, 0fBF3504F3;
fma.rn.f32 f401, f391, 0f3F3504F3, f400;
add.f32 f402, f369, f385;
add.f32 f403, f370, f386;
sub.f32 f404, f369, f385;
sub.f32 f405, f370, f386;
add.f32 f406, f373, f395;
add.f32 f407, f374, f396;
sub.f32 f408, f373, f395;
sub.f32 f409, f374, f396;
sub.f32 f410, f371, f388;
add.f32 f411, f372, f387;
add.f32 f412, f371, f388;
sub.f32 f413, f372, f387;
add.f32 f414, f375, f399;
add.f32 f415, f376, f401;
sub.f32 f416, f375, f399;
sub.f32 f417, f376, f401;
mul.f32 f418, f406, 0f3F6C835E;
mul.f32 f419, f407, 0f3EC3EF15;
sub.f32 f420, f418, f419;
mul.f32 f421, f407, 0f3F6C835E;
fma.rn.f32 f422, f406, 0f3EC3EF15, f421;
mul.f32 f423, f410, 0f3F3504F3;
mul.f32 f424, f411, 0f3F3504F3;
sub.f32 f425, f423, f424;
add.f32 f426, f423, f424;
mul.f32 f427, f414, 0f3EC3EF15;
mul.f32 f428, f415, 0f3F6C835E;
sub.f32 f429, f427, f428;
mul.f32 f430, f415, 0f3EC3EF15;
fma.rn.f32 f431, f414, 0f3F6C835E, f430;
mul.f32 f432, f408, 0fBEC3EF15;
mul.f32 f433, f409, 0f3F6C835E;
sub.f32 f434, f432, f433;
mul.f32 f435, f409, 0fBEC3EF15;
fma.rn.f32 f436, f408, 0f3F6C835E, f435;
mul.f32 f437, f412, 0fBF3504F3;
mul.f32 f438, f413, 0f3F3504F3;
sub.f32 f439, f437, f438;
mul.f32 f440, f413, 0fBF3504F3;
fma.rn.f32 f441, f412, 0f3F3504F3, f440;
mul.f32 f442, f416, 0fBF6C835E;
mul.f32 f443, f417, 0f3EC3EF15;
sub.f32 f444, f442, f443;
mul.f32 f445, f417, 0fBF6C835E;
fma.rn.f32 f446, f416, 0f3EC3EF15, f445;
add.f32 f447, f345, f402;
add.f32 f448, f346, f403;
sub.f32 f449, f345, f402;
sub.f32 f450, f346, f403;
add.f32 f451, f349, f420;
add.f32 f452, f350, f422;
sub.f32 f453, f349, f420;
sub.f32 f454, f350, f422;
add.f32 f455, f353, f425;
add.f32 f456, f354, f426;
sub.f32 f457, f353, f425;
sub.f32 f458, f354, f426;
add.f32 f459, f357, f429;
add.f32 f460, f358, f431;
sub.f32 f461, f357, f429;
sub.f32 f462, f358, f431;
sub.f32 f463, f347, f405;
add.f32 f464, f348, f404;
add.f32 f465, f347, f405;
sub.f32 f466, f348, f404;
add.f32 f467, f351, f434;
add.f32 f468, f352, f436;
sub.f32 f469, f351, f434;
sub.f32 f470, f352, f436;
add.f32 f471, f355, f439;
add.f32 f472, f356, f441;
sub.f32 f473, f355, f439;
sub.f32 f474, f356, f441;
add.f32 f475, f359, f444;
add.f32 f476, f360, f446;
sub.f32 f477, f359, f444;
sub.f32 f478, f360, f446;
mul.f32 f479, f451, 0f3F7B14BE;
mul.f32 f480, f452, 0f3E47C5C2;
sub.f32 f481, f479, f480;
mul.f32 f482, f452, 0f3F7B14BE;
fma.rn.f32 f483, f451, 0f3E47C5C2, f482;
mul.f32 f484, f455, 0f3F6C835E;
mul.f32 f485, f456, 0f3EC3EF15;
sub.f32 f486, f484, f485;
mul.f32 f487, f456, 0f3F6C835E;
fma.rn.f32 f488, f455, 0f3EC3EF15, f487;
mul.f32 f489, f459, 0f3F54DB31;
mul.f32 f490, f460, 0f3F0E39DA;
sub.f32 f491, f489, f490;
mul.f32 f492, f460, 0f3F54DB31;
fma.rn.f32 f493, f459, 0f3F0E39DA, f492;
mul.f32 f494, f463, 0f3F3504F3;
mul.f32 f495, f464, 0f3F3504F3;
sub.f32 f496, f494, f495;
add.f32 f497, f494, f495;
mul.f32 f498, f467, 0f3F0E39DA;
mul.f32 f499, f468, 0f3F54DB31;
sub.f32 f500, f498, f499;
mul.f32 f501, f468, 0f3F0E39DA;
fma.rn.f32 f502, f467, 0f3F54DB31, f501;
mul.f32 f503, f471, 0f3EC3EF15;
mul.f32 f504, f472, 0f3F6C835E;
sub.f32 f505, f503, f504;
mul.f32 f506, f472, 0f3EC3EF15;
fma.rn.f32 f507, f471, 0f3F6C835E, f506;
mul.f32 f508, f475, 0f3E47C5C2;
mul.f32 f509, f476, 0f3F7B14BE;
sub.f32 f510, f508, f509;
mul.f32 f511, f476, 0f3E47C5C2;
fma.rn.f32 f512, f475, 0f3F7B14BE, f511;
mul.f32 f513, f453, 0fBE47C5C2;
mul.f32 f514, f454, 0f3F7B14BE;
sub.f32 f515, f513, f514;
mul.f32 f516, f454, 0fBE47C5C2;
fma.rn.f32 f517, f453, 0f3F7B14BE, f516;
mul.f32 f518, f457, 0fBEC3EF15;
mul.f32 f519, f458, 0f3F6C835E;
sub.f32 f520, f518, f519;
mul.f32 f521, f458, 0fBEC3EF15;
fma.rn.f32 f522, f457, 0f3F6C835E, f521;
mul.f32 f523, f461, 0fBF0E39DA;
mul.f32 f524, f462, 0f3F54DB31;
sub.f32 f525, f523, f524;
mul.f32 f526, f462, 0fBF0E39DA;
fma.rn.f32 f527, f461, 0f3F54DB31, f526;
mul.f32 f528, f465, 0fBF3504F3;
mul.f32 f529, f466, 0f3F3504F3;
sub.f32 f530, f528, f529;
mul.f32 f531, f466, 0fBF3504F3;
fma.rn.f32 f532, f465, 0f3F3504F3, f531;
mul.f32 f533, f469, 0fBF54DB31;
mul.f32 f534, f470, 0f3F0E39DA;
sub.f32 f535, f533, f534;
mul.f32 f536, f470, 0fBF54DB31;
fma.rn.f32 f537, f469, 0f3F0E39DA, f536;
mul.f32 f538, f473, 0fBF6C835E;
mul.f32 f539, f474, 0f3EC3EF15;
sub.f32 f540, f538, f539;
mul.f32 f541, f474, 0fBF6C835E;
fma.rn.f32 f542, f473, 0f3EC3EF15, f541;
mul.f32 f543, f477, 0fBF7B14BE;
mul.f32 f544, f478, 0f3E47C5C2;
sub.f32 f545, f543, f544;
mul.f32 f546, f478, 0fBF7B14BE;
fma.rn.f32 f547, f477, 0f3E47C5C2, f546;
add.f32 %1, f273, f448;
add.f32 %0, f272, f447;
add.f32 %3, f277, f483;
add.f32 %2, f276, f481;
add.f32 %5, f281, f488;
add.f32 %4, f280, f486;
add.f32 %7, f285, f493;
add.f32 %6, f284, f491;
add.f32 %9, f289, f497;
add.f32 %8, f288, f496;
add.f32 %11, f293, f502;
add.f32 %10, f292, f500;
add.f32 %13, f297, f507;
add.f32 %12, f296, f505;
add.f32 %15, f301, f512;
add.f32 %14, f300, f510;
add.f32 %17, f275, f449;
sub.f32 %16, f274, f450;
add.f32 %19, f279, f517;
add.f32 %18, f278, f515;
add.f32 %21, f283, f522;
add.f32 %20, f282, f520;
add.f32 %23, f287, f527;
add.f32 %22, f286, f525;
add.f32 %25, f291, f532;
add.f32 %24, f290, f530;
add.f32 %27, f295, f537;
add.f32 %26, f294, f535;
add.f32 %29, f299, f542;
add.f32 %28, f298, f540;
add.f32 %31, f303, f547;
add.f32 %30, f302, f545;
sub.f32 %33, f273, f448;
sub.f32 %32, f272, f447;
sub.f32 %35, f277, f483;
sub.f32 %34, f276, f481;
sub.f32 %37, f281, f488;
sub.f32 %36, f280, f486;
sub.f32 %39, f285, f493;
sub.f32 %38, f284, f491;
sub.f32 %41, f289, f497;
sub.f32 %40, f288, f496;
sub.f32 %43, f293, f502;
sub.f32 %42, f292, f500;
sub.f32 %45, f297, f507;
sub.f32 %44, f296, f505;
sub.f32 %47, f301, f512;
sub.f32 %46, f300, f510;
sub.f32 %49, f275, f449;
add.f32 %48, f274, f450;
sub.f32 %51, f279, f517;
sub.f32 %50, f278, f515;
sub.f32 %53, f283, f522;
sub.f32 %52, f282, f520;
sub.f32 %55, f287, f527;
sub.f32 %54, f286, f525;
sub.f32 %57, f291, f532;
sub.f32 %56, f290, f530;
sub.f32 %59, f295, f537;
sub.f32 %58, f294, f535;
sub.f32 %61, f299, f542;
sub.f32 %60, f298, f540;
sub.f32 %63, f303, f547;
sub.f32 %62, f302, f545;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y), "=f"(rmem[30].x), "=f"(rmem[30].y), "=f"(rmem[31].x), "=f"(rmem[31].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y), "f"(rmem[29].y), "f"(rmem[30].x), "f"(rmem[30].y), "f"(rmem[31].x), "f"(rmem[31].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<235, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<223>;
.reg .b32 r<14>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %18, %28;
add.f32 f34, %19, %30;
sub.f32 f35, %18, %28;
sub.f32 f36, %19, %30;
add.f32 f37, %23, %34;
add.f32 f38, %25, %35;
sub.f32 f39, %23, %34;
sub.f32 f40, %25, %35;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
sub.f32 f45, f35, f40;
add.f32 f46, f36, f39;
add.f32 f47, f35, f40;
sub.f32 f48, f36, f39;
add.f32 f49, %20, %31;
add.f32 f50, %22, %33;
sub.f32 f51, %20, %31;
sub.f32 f52, %22, %33;
add.f32 f53, %26, %36;
add.f32 f54, %27, %37;
sub.f32 f55, %26, %36;
sub.f32 f56, %27, %37;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
sub.f32 f61, f51, f56;
add.f32 f62, f52, f55;
add.f32 f63, f51, f56;
sub.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0f3F3504F3;
sub.f32 f67, f65, f66;
add.f32 f68, f65, f66;
mul.f32 f69, f63, 0fBF3504F3;
mul.f32 f70, f64, 0f3F3504F3;
sub.f32 f71, f69, f70;
mul.f32 f72, f64, 0fBF3504F3;
fma.rn.f32 f73, f63, 0f3F3504F3, f72;
sub.f32 f74, f41, f57;
sub.f32 f75, f42, f58;
add.f32 f76, f45, f67;
add.f32 f77, f46, f68;
sub.f32 f78, f45, f67;
sub.f32 f79, f46, f68;
sub.f32 f80, f43, f60;
add.f32 f81, f44, f59;
add.f32 f82, f43, f60;
sub.f32 f83, f44, f59;
add.f32 f84, f47, f71;
add.f32 f85, f48, f73;
sub.f32 f86, f47, f71;
sub.f32 f87, f48, f73;
and.b32 r6, r5, 3;
shl.b32 r7, r5, 6;
and.b32 r8, r7, -256;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 24;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f88, f89}, [rd5];
mul.f32 f92, f77, f89;
mul.f32 f93, f76, f89;
mul.f32 f94, f88, f77;
mul.f32 f95, f88, f88;
mul.f32 f96, f89, f89;
sub.f32 f97, f95, f96;
mul.f32 f98, f89, f88;
fma.rn.f32 f99, f89, f88, f98;
mul.f32 f100, f81, f99;
mul.f32 f101, f80, f99;
mul.f32 f102, f97, f81;
mul.f32 f103, f88, f97;
mul.f32 f104, f89, f99;
sub.f32 f105, f103, f104;
mul.f32 f106, f88, f99;
fma.rn.f32 f107, f89, f97, f106;
mul.f32 f108, f85, f107;
mul.f32 f109, f84, f107;
mul.f32 f110, f105, f85;
mul.f32 f111, f88, f105;
mul.f32 f112, f89, f107;
sub.f32 f113, f111, f112;
mul.f32 f114, f88, f107;
fma.rn.f32 f115, f89, f105, f114;
mul.f32 f116, f75, f115;
mul.f32 f117, f74, f115;
mul.f32 f118, f113, f75;
mul.f32 f119, f88, f113;
mul.f32 f120, f89, f115;
sub.f32 f121, f119, f120;
mul.f32 f122, f88, f115;
fma.rn.f32 f123, f89, f113, f122;
mul.f32 f124, f79, f123;
mul.f32 f125, f78, f123;
mul.f32 f126, f121, f79;
mul.f32 f127, f88, f121;
mul.f32 f128, f89, f123;
sub.f32 f129, f127, f128;
mul.f32 f130, f88, f123;
fma.rn.f32 f131, f89, f121, f130;
mul.f32 f132, f83, f131;
mul.f32 f133, f82, f131;
mul.f32 f134, f129, f83;
mul.f32 f135, f88, f129;
mul.f32 f136, f89, f131;
sub.f32 f137, f135, f136;
mul.f32 f138, f88, f131;
fma.rn.f32 f139, f89, f129, f138;
mul.f32 f140, f87, f139;
mul.f32 f141, f86, f139;
mul.f32 f142, f137, f87;
barrier.sync 0;
and.b32 r11, r7, 192;
add.s32 r12, r9, r11;
add.f32 f143, f42, f58;
add.f32 f144, f41, f57;
fma.rn.f32 f145, f88, f76, f92;
sub.f32 f146, f94, f93;
st.shared.v4.f32 [r12], {f144, f143, f145, f146};
fma.rn.f32 f147, f97, f80, f100;
sub.f32 f148, f102, f101;
sub.f32 f149, f110, f109;
fma.rn.f32 f150, f105, f84, f108;
st.shared.v4.f32 [r12+16], {f147, f148, f150, f149};
fma.rn.f32 f151, f113, f74, f116;
sub.f32 f152, f118, f117;
fma.rn.f32 f153, f121, f78, f124;
sub.f32 f154, f126, f125;
st.shared.v4.f32 [r12+32], {f151, f152, f153, f154};
fma.rn.f32 f155, f129, f82, f132;
sub.f32 f156, f134, f133;
fma.rn.f32 f157, f137, f86, f140;
sub.f32 f158, f142, f141;
st.shared.v4.f32 [r12+48], {f155, f156, f157, f158};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.v2.f32 {f159, f160}, [r13];
ld.shared.v2.f32 {f163, f164}, [r13+32];
ld.shared.v2.f32 {f167, f168}, [r13+64];
ld.shared.v2.f32 {f171, f172}, [r13+96];
ld.shared.v2.f32 {f175, f176}, [r13+128];
ld.shared.v2.f32 {f179, f180}, [r13+160];
ld.shared.v2.f32 {f183, f184}, [r13+192];
ld.shared.v2.f32 {f187, f188}, [r13+224];
add.f32 f191, f159, f175;
add.f32 f192, f160, f176;
sub.f32 f193, f159, f175;
sub.f32 f194, f160, f176;
add.f32 f195, f167, f183;
add.f32 f196, f168, f184;
sub.f32 f197, f167, f183;
sub.f32 f198, f168, f184;
add.f32 f199, f163, f179;
add.f32 f200, f164, f180;
sub.f32 f201, f163, f179;
sub.f32 f202, f164, f180;
add.f32 f203, f171, f187;
add.f32 f204, f172, f188;
sub.f32 f205, f171, f187;
sub.f32 f206, f172, f188;
add.f32 %1, f192, f196;
add.f32 %0, f191, f195;
add.f32 %3, f200, f204;
add.f32 %2, f199, f203;
add.f32 %5, f194, f197;
sub.f32 %4, f193, f198;
add.f32 %7, f202, f205;
sub.f32 %6, f201, f206;
sub.f32 %9, f192, f196;
sub.f32 %8, f191, f195;
sub.f32 %11, f200, f204;
sub.f32 %10, f199, f203;
sub.f32 %13, f194, f197;
add.f32 %12, f193, f198;
sub.f32 %15, f202, f205;
add.f32 %14, f201, f206;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<236, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<207>;
.reg .b32 r<14>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %18, %28;
add.f32 f34, %19, %30;
sub.f32 f35, %18, %28;
sub.f32 f36, %19, %30;
add.f32 f37, %23, %34;
add.f32 f38, %25, %35;
sub.f32 f39, %23, %34;
sub.f32 f40, %25, %35;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
sub.f32 f45, f35, f40;
add.f32 f46, f36, f39;
add.f32 f47, f35, f40;
sub.f32 f48, f36, f39;
add.f32 f49, %20, %31;
add.f32 f50, %22, %33;
sub.f32 f51, %20, %31;
sub.f32 f52, %22, %33;
add.f32 f53, %26, %36;
add.f32 f54, %27, %37;
sub.f32 f55, %26, %36;
sub.f32 f56, %27, %37;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
sub.f32 f61, f51, f56;
add.f32 f62, f52, f55;
add.f32 f63, f51, f56;
sub.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0f3F3504F3;
sub.f32 f67, f65, f66;
add.f32 f68, f65, f66;
mul.f32 f69, f63, 0fBF3504F3;
mul.f32 f70, f64, 0f3F3504F3;
sub.f32 f71, f69, f70;
mul.f32 f72, f64, 0fBF3504F3;
fma.rn.f32 f73, f63, 0f3F3504F3, f72;
add.f32 f74, f41, f57;
add.f32 f75, f42, f58;
sub.f32 f76, f41, f57;
sub.f32 f77, f42, f58;
add.f32 f78, f45, f67;
add.f32 f79, f46, f68;
sub.f32 f80, f45, f67;
sub.f32 f81, f46, f68;
sub.f32 f82, f43, f60;
add.f32 f83, f44, f59;
add.f32 f84, f43, f60;
sub.f32 f85, f44, f59;
add.f32 f86, f47, f71;
add.f32 f87, f48, f73;
sub.f32 f88, f47, f71;
sub.f32 f89, f48, f73;
and.b32 r6, r5, 3;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 24;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f90, f91}, [rd5];
mul.f32 f94, f79, f91;
fma.rn.f32 f95, f90, f78, f94;
mul.f32 f96, f78, f91;
mul.f32 f97, f90, f79;
sub.f32 f98, f97, f96;
mul.f32 f99, f90, f90;
mul.f32 f100, f91, f91;
sub.f32 f101, f99, f100;
mul.f32 f102, f91, f90;
fma.rn.f32 f103, f91, f90, f102;
mul.f32 f104, f83, f103;
fma.rn.f32 f105, f101, f82, f104;
mul.f32 f106, f82, f103;
mul.f32 f107, f101, f83;
sub.f32 f108, f107, f106;
mul.f32 f109, f90, f101;
mul.f32 f110, f91, f103;
sub.f32 f111, f109, f110;
mul.f32 f112, f90, f103;
fma.rn.f32 f113, f91, f101, f112;
mul.f32 f114, f87, f113;
fma.rn.f32 f115, f111, f86, f114;
mul.f32 f116, f86, f113;
mul.f32 f117, f111, f87;
sub.f32 f118, f117, f116;
mul.f32 f119, f90, f111;
mul.f32 f120, f91, f113;
sub.f32 f121, f119, f120;
mul.f32 f122, f90, f113;
fma.rn.f32 f123, f91, f111, f122;
mul.f32 f124, f77, f123;
fma.rn.f32 f125, f121, f76, f124;
mul.f32 f126, f76, f123;
mul.f32 f127, f121, f77;
sub.f32 f128, f127, f126;
mul.f32 f129, f90, f121;
mul.f32 f130, f91, f123;
sub.f32 f131, f129, f130;
mul.f32 f132, f90, f123;
fma.rn.f32 f133, f91, f121, f132;
mul.f32 f134, f81, f133;
fma.rn.f32 f135, f131, f80, f134;
mul.f32 f136, f80, f133;
mul.f32 f137, f131, f81;
sub.f32 f138, f137, f136;
mul.f32 f139, f90, f131;
mul.f32 f140, f91, f133;
sub.f32 f141, f139, f140;
mul.f32 f142, f90, f133;
fma.rn.f32 f143, f91, f131, f142;
mul.f32 f144, f85, f143;
fma.rn.f32 f145, f141, f84, f144;
mul.f32 f146, f84, f143;
mul.f32 f147, f141, f85;
sub.f32 f148, f147, f146;
mul.f32 f149, f90, f141;
mul.f32 f150, f91, f143;
sub.f32 f151, f149, f150;
mul.f32 f152, f90, f143;
fma.rn.f32 f153, f91, f141, f152;
mul.f32 f154, f89, f153;
fma.rn.f32 f155, f151, f88, f154;
mul.f32 f156, f88, f153;
mul.f32 f157, f151, f89;
sub.f32 f158, f157, f156;
shl.b32 r8, r5, 5;
and.b32 r9, r8, -128;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 96;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f74, f95, f105, f115};
st.shared.v4.f32 [r12+16], {f125, f135, f145, f155};
barrier.sync 0;
mad.lo.s32 r13, r6, -28, r12;
ld.shared.f32 f159, [r13];
ld.shared.f32 f160, [r13+16];
ld.shared.f32 f161, [r13+32];
ld.shared.f32 f162, [r13+48];
ld.shared.f32 f163, [r13+64];
ld.shared.f32 f164, [r13+80];
ld.shared.f32 f165, [r13+96];
ld.shared.f32 f166, [r13+112];
barrier.sync 0;
st.shared.v4.f32 [r12], {f75, f98, f108, f118};
st.shared.v4.f32 [r12+16], {f128, f138, f148, f158};
barrier.sync 0;
ld.shared.f32 f167, [r13];
ld.shared.f32 f168, [r13+16];
ld.shared.f32 f169, [r13+32];
ld.shared.f32 f170, [r13+48];
ld.shared.f32 f171, [r13+64];
ld.shared.f32 f172, [r13+80];
ld.shared.f32 f173, [r13+96];
ld.shared.f32 f174, [r13+112];
add.f32 f175, f159, f163;
add.f32 f176, f167, f171;
sub.f32 f177, f159, f163;
sub.f32 f178, f167, f171;
add.f32 f179, f161, f165;
add.f32 f180, f169, f173;
sub.f32 f181, f161, f165;
sub.f32 f182, f169, f173;
add.f32 f183, f160, f164;
add.f32 f184, f168, f172;
sub.f32 f185, f160, f164;
sub.f32 f186, f168, f172;
add.f32 f187, f162, f166;
add.f32 f188, f170, f174;
sub.f32 f189, f162, f166;
sub.f32 f190, f170, f174;
add.f32 %0, f175, f179;
add.f32 %1, f176, f180;
add.f32 %2, f183, f187;
add.f32 %3, f184, f188;
add.f32 %5, f178, f181;
sub.f32 %4, f177, f182;
add.f32 %7, f186, f189;
sub.f32 %6, f185, f190;
sub.f32 %8, f175, f179;
sub.f32 %9, f176, f180;
sub.f32 %10, f183, f187;
sub.f32 %11, f184, f188;
sub.f32 %13, f178, f181;
add.f32 %12, f177, f182;
sub.f32 %15, f186, f189;
add.f32 %14, f185, f190;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<237, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<147>;
.reg .b32 r<21>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %11, %16;
add.f32 f18, %12, %18;
sub.f32 f19, %11, %16;
sub.f32 f20, %12, %18;
add.f32 f21, %13, %19;
add.f32 f22, %15, %20;
sub.f32 f23, %13, %19;
sub.f32 f24, %15, %20;
sub.f32 f25, f17, f21;
sub.f32 f26, f18, f22;
sub.f32 f27, f19, f24;
add.f32 f28, f20, f23;
add.f32 f29, f19, f24;
sub.f32 f30, f20, f23;
and.b32 r6, r5, 7;
shl.b32 r7, r5, 5;
and.b32 r8, r7, -256;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 56;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f31, f32}, [rd5];
mul.f32 f35, f28, f32;
mul.f32 f36, f27, f32;
mul.f32 f37, f31, f28;
mul.f32 f38, f31, f31;
mul.f32 f39, f32, f32;
sub.f32 f40, f38, f39;
mul.f32 f41, f32, f31;
fma.rn.f32 f42, f32, f31, f41;
mul.f32 f43, f26, f42;
mul.f32 f44, f25, f42;
mul.f32 f45, f40, f26;
mul.f32 f46, f31, f40;
mul.f32 f47, f32, f42;
sub.f32 f48, f46, f47;
mul.f32 f49, f31, f42;
fma.rn.f32 f50, f32, f40, f49;
mul.f32 f51, f30, f50;
mul.f32 f52, f29, f50;
mul.f32 f53, f48, f30;
barrier.sync 0;
and.b32 r11, r7, 224;
add.s32 r12, r9, r11;
add.f32 f54, f18, f22;
add.f32 f55, f17, f21;
fma.rn.f32 f56, f31, f27, f35;
sub.f32 f57, f37, f36;
st.shared.v4.f32 [r12], {f55, f54, f56, f57};
sub.f32 f58, f45, f44;
fma.rn.f32 f59, f40, f25, f43;
fma.rn.f32 f60, f48, f29, f51;
sub.f32 f61, f53, f52;
st.shared.v4.f32 [r12+16], {f59, f58, f60, f61};
barrier.sync 0;
mad.lo.s32 r13, r6, -24, r12;
ld.shared.v2.f32 {f62, f63}, [r13];
ld.shared.v2.f32 {f66, f67}, [r13+64];
ld.shared.v2.f32 {f70, f71}, [r13+128];
ld.shared.v2.f32 {f74, f75}, [r13+192];
add.f32 f78, f62, f70;
add.f32 f79, f63, f71;
sub.f32 f80, f62, f70;
sub.f32 f81, f63, f71;
add.f32 f82, f66, f74;
add.f32 f83, f67, f75;
sub.f32 f84, f66, f74;
sub.f32 f85, f67, f75;
sub.f32 f86, f78, f82;
sub.f32 f87, f79, f83;
sub.f32 f88, f80, f85;
add.f32 f89, f81, f84;
add.f32 f90, f80, f85;
sub.f32 f91, f81, f84;
and.b32 r14, r5, 4;
bfe.u32 r15, r5, 2, 1;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f92, f93}, [rd8];
mul.f32 f96, f89, f93;
mul.f32 f97, f88, f93;
mul.f32 f98, f92, f89;
mul.f32 f99, f92, f92;
mul.f32 f100, f93, f93;
sub.f32 f101, f99, f100;
mul.f32 f102, f93, f92;
fma.rn.f32 f103, f93, f92, f102;
mul.f32 f104, f87, f103;
mul.f32 f105, f86, f103;
mul.f32 f106, f101, f87;
mul.f32 f107, f92, f101;
mul.f32 f108, f93, f103;
sub.f32 f109, f107, f108;
mul.f32 f110, f92, f103;
fma.rn.f32 f111, f93, f101, f110;
mul.f32 f112, f91, f111;
mul.f32 f113, f90, f111;
mul.f32 f114, f109, f91;
and.b32 r16, r10, 24;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 128;
add.s32 r19, r17, r18;
add.f32 f115, f79, f83;
add.f32 f116, f78, f82;
st.shared.v2.f32 [r19], {f116, f115};
fma.rn.f32 f117, f92, f88, f96;
sub.f32 f118, f98, f97;
st.shared.v2.f32 [r19+32], {f117, f118};
fma.rn.f32 f119, f101, f86, f104;
sub.f32 f120, f106, f105;
st.shared.v2.f32 [r19+64], {f119, f120};
sub.f32 f121, f114, f113;
fma.rn.f32 f122, f109, f90, f112;
st.shared.v2.f32 [r19+96], {f122, f121};
barrier.sync 0;
mad.lo.s32 r20, r14, -24, r19;
ld.shared.v2.f32 {f123, f124}, [r20];
ld.shared.v2.f32 {f127, f128}, [r20+64];
ld.shared.v2.f32 {f131, f132}, [r20+128];
ld.shared.v2.f32 {f135, f136}, [r20+192];
add.f32 %1, f124, f132;
add.f32 %0, f123, f131;
add.f32 %3, f128, f136;
add.f32 %2, f127, f135;
sub.f32 %5, f124, f132;
sub.f32 %4, f123, f131;
sub.f32 %7, f128, f136;
sub.f32 %6, f127, f135;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<238, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<131>;
.reg .b32 r<22>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %11, %16;
add.f32 f18, %12, %18;
sub.f32 f19, %11, %16;
sub.f32 f20, %12, %18;
add.f32 f21, %13, %19;
add.f32 f22, %15, %20;
sub.f32 f23, %13, %19;
sub.f32 f24, %15, %20;
add.f32 f25, f17, f21;
add.f32 f26, f18, f22;
sub.f32 f27, f17, f21;
sub.f32 f28, f18, f22;
sub.f32 f29, f19, f24;
add.f32 f30, f20, f23;
add.f32 f31, f19, f24;
sub.f32 f32, f20, f23;
and.b32 r6, r5, 7;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 56;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f33, f34}, [rd5];
mul.f32 f37, f30, f34;
fma.rn.f32 f38, f33, f29, f37;
mul.f32 f39, f29, f34;
mul.f32 f40, f33, f30;
sub.f32 f41, f40, f39;
mul.f32 f42, f33, f33;
mul.f32 f43, f34, f34;
sub.f32 f44, f42, f43;
mul.f32 f45, f34, f33;
fma.rn.f32 f46, f34, f33, f45;
mul.f32 f47, f28, f46;
fma.rn.f32 f48, f44, f27, f47;
mul.f32 f49, f27, f46;
mul.f32 f50, f44, f28;
sub.f32 f51, f50, f49;
mul.f32 f52, f33, f44;
mul.f32 f53, f34, f46;
sub.f32 f54, f52, f53;
mul.f32 f55, f33, f46;
fma.rn.f32 f56, f34, f44, f55;
mul.f32 f57, f32, f56;
fma.rn.f32 f58, f54, f31, f57;
mul.f32 f59, f31, f56;
mul.f32 f60, f54, f32;
sub.f32 f61, f60, f59;
shl.b32 r8, r5, 4;
and.b32 r9, r8, -128;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 112;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f25, f38, f48, f58};
barrier.sync 0;
mad.lo.s32 r13, r6, -12, r12;
ld.shared.f32 f62, [r13];
ld.shared.f32 f63, [r13+32];
ld.shared.f32 f64, [r13+64];
ld.shared.f32 f65, [r13+96];
barrier.sync 0;
st.shared.v4.f32 [r12], {f26, f41, f51, f61};
barrier.sync 0;
ld.shared.f32 f66, [r13];
ld.shared.f32 f67, [r13+32];
ld.shared.f32 f68, [r13+64];
ld.shared.f32 f69, [r13+96];
add.f32 f70, f62, f64;
add.f32 f71, f66, f68;
sub.f32 f72, f62, f64;
sub.f32 f73, f66, f68;
add.f32 f74, f63, f65;
add.f32 f75, f67, f69;
sub.f32 f76, f63, f65;
sub.f32 f77, f67, f69;
add.f32 f78, f70, f74;
add.f32 f79, f71, f75;
sub.f32 f80, f70, f74;
sub.f32 f81, f71, f75;
sub.f32 f82, f72, f77;
add.f32 f83, f73, f76;
add.f32 f84, f72, f77;
sub.f32 f85, f73, f76;
and.b32 r14, r5, 4;
bfe.u32 r15, r5, 2, 1;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f86, f87}, [rd8];
mul.f32 f90, f83, f87;
fma.rn.f32 f91, f86, f82, f90;
mul.f32 f92, f82, f87;
mul.f32 f93, f86, f83;
sub.f32 f94, f93, f92;
mul.f32 f95, f86, f86;
mul.f32 f96, f87, f87;
sub.f32 f97, f95, f96;
mul.f32 f98, f87, f86;
fma.rn.f32 f99, f87, f86, f98;
mul.f32 f100, f81, f99;
fma.rn.f32 f101, f97, f80, f100;
mul.f32 f102, f80, f99;
mul.f32 f103, f97, f81;
sub.f32 f104, f103, f102;
mul.f32 f105, f86, f97;
mul.f32 f106, f87, f99;
sub.f32 f107, f105, f106;
mul.f32 f108, f86, f99;
fma.rn.f32 f109, f87, f97, f108;
mul.f32 f110, f85, f109;
fma.rn.f32 f111, f107, f84, f110;
mul.f32 f112, f84, f109;
mul.f32 f113, f107, f85;
sub.f32 f114, f113, f112;
shl.b32 r16, r5, 2;
and.b32 r17, r16, 12;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 64;
add.s32 r20, r18, r19;
st.shared.f32 [r20], f78;
st.shared.f32 [r20+16], f91;
st.shared.f32 [r20+32], f101;
st.shared.f32 [r20+48], f111;
barrier.sync 0;
mad.lo.s32 r21, r14, -12, r20;
ld.shared.f32 f115, [r21];
ld.shared.f32 f116, [r21+32];
ld.shared.f32 f117, [r21+64];
ld.shared.f32 f118, [r21+96];
barrier.sync 0;
st.shared.f32 [r20], f79;
st.shared.f32 [r20+16], f94;
st.shared.f32 [r20+32], f104;
st.shared.f32 [r20+48], f114;
barrier.sync 0;
ld.shared.f32 f119, [r21];
ld.shared.f32 f120, [r21+32];
ld.shared.f32 f121, [r21+64];
ld.shared.f32 f122, [r21+96];
add.f32 %0, f115, f117;
add.f32 %1, f119, f121;
add.f32 %2, f116, f118;
add.f32 %3, f120, f122;
sub.f32 %4, f115, f117;
sub.f32 %5, f119, f121;
sub.f32 %6, f116, f118;
sub.f32 %7, f120, f122;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<239, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<97>;
.reg .b32 r<35>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
sub.f32 f9, %9, %11;
sub.f32 f10, %10, %12;
shl.b32 r6, r5, 4;
and.b32 r7, r6, -256;
add.s32 r8, r4, r7;
shl.b32 r9, r5, 3;
cvt.u64.u32 rd2, r9;
and.b64 rd3, rd2, 120;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f11, f12}, [rd5];
mul.f32 f15, f10, f12;
mul.f32 f16, f9, f12;
mul.f32 f17, f11, f10;
barrier.sync 0;
and.b32 r10, r6, 240;
add.s32 r11, r8, r10;
add.f32 f18, %10, %12;
add.f32 f19, %9, %11;
st.shared.v2.f32 [r11], {f19, f18};
sub.f32 f20, f17, f16;
fma.rn.f32 f21, f11, f9, f15;
st.shared.v2.f32 [r11+8], {f21, f20};
barrier.sync 0;
and.b32 r12, r9, 120;
sub.s32 r13, r11, r12;
ld.shared.v2.f32 {f22, f23}, [r13];
ld.shared.v2.f32 {f26, f27}, [r13+128];
sub.f32 f30, f22, f26;
sub.f32 f31, f23, f27;
bfe.u32 r14, r5, 1, 3;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f32, f33}, [rd8];
mul.f32 f36, f31, f33;
mul.f32 f37, f30, f33;
mul.f32 f38, f32, f31;
and.b32 r15, r9, 8;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 224;
add.s32 r18, r16, r17;
add.f32 f39, f23, f27;
add.f32 f40, f22, f26;
st.shared.v2.f32 [r18], {f40, f39};
fma.rn.f32 f41, f32, f30, f36;
sub.f32 f42, f38, f37;
st.shared.v2.f32 [r18+16], {f41, f42};
barrier.sync 0;
and.b32 r19, r9, 112;
sub.s32 r20, r18, r19;
ld.shared.v2.f32 {f43, f44}, [r20];
ld.shared.v2.f32 {f47, f48}, [r20+128];
sub.f32 f51, f43, f47;
sub.f32 f52, f44, f48;
bfe.u32 r21, r5, 2, 2;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f53, f54}, [rd11];
mul.f32 f57, f52, f54;
mul.f32 f58, f51, f54;
mul.f32 f59, f53, f52;
and.b32 r22, r9, 24;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 192;
add.s32 r25, r23, r24;
add.f32 f60, f44, f48;
add.f32 f61, f43, f47;
st.shared.v2.f32 [r25], {f61, f60};
fma.rn.f32 f62, f53, f51, f57;
sub.f32 f63, f59, f58;
st.shared.v2.f32 [r25+32], {f62, f63};
barrier.sync 0;
and.b32 r26, r9, 96;
sub.s32 r27, r25, r26;
ld.shared.v2.f32 {f64, f65}, [r27];
ld.shared.v2.f32 {f68, f69}, [r27+128];
sub.f32 f72, f64, f68;
sub.f32 f73, f65, f69;
and.b32 r28, r5, 8;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f74, f75}, [rd14];
mul.f32 f78, f73, f75;
mul.f32 f79, f72, f75;
mul.f32 f80, f74, f73;
and.b32 r29, r9, 56;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 128;
add.s32 r32, r30, r31;
add.f32 f81, f65, f69;
add.f32 f82, f64, f68;
st.shared.v2.f32 [r32], {f82, f81};
fma.rn.f32 f83, f74, f72, f78;
sub.f32 f84, f80, f79;
st.shared.v2.f32 [r32+64], {f83, f84};
barrier.sync 0;
and.b32 r33, r9, 64;
sub.s32 r34, r32, r33;
ld.shared.v2.f32 {f85, f86}, [r34];
ld.shared.v2.f32 {f89, f90}, [r34+128];
add.f32 %1, f86, f90;
add.f32 %0, f85, f89;
sub.f32 %3, f86, f90;
sub.f32 %2, f85, f89;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<240, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<587>;
.reg .b32 r<24>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f32 f65, %34, %50;
sub.f32 f67, %34, %50;
add.f32 f582, %35, %66;
sub.f32 f68, %35, %66;
add.f32 f69, %42, %58;
sub.f32 f71, %42, %58;
add.f32 f580, %67, %59;
sub.f32 f72, %67, %59;
add.f32 f73, f65, f69;
sub.f32 f75, f65, f69;
add.f32 f579, f582, f580;
sub.f32 f76, f582, f580;
sub.f32 f77, f67, f72;
add.f32 f79, f67, f72;
add.f32 f578, f68, f71;
sub.f32 f80, f68, f71;
add.f32 f81, %38, %54;
sub.f32 f83, %38, %54;
add.f32 f575, %69, %68;
sub.f32 f84, %69, %68;
add.f32 f85, %46, %62;
sub.f32 f87, %46, %62;
add.f32 f573, %47, %70;
sub.f32 f88, %47, %70;
add.f32 f89, f81, f85;
sub.f32 f91, f81, f85;
add.f32 f572, f575, f573;
sub.f32 f92, f575, f573;
sub.f32 f93, f83, f88;
add.f32 f95, f83, f88;
add.f32 f571, f84, f87;
sub.f32 f96, f84, f87;
mul.f32 f97, f93, 0f3F3504F3;
mul.f32 f98, f571, 0f3F3504F3;
sub.f32 f99, f97, f98;
add.f32 f100, f97, f98;
mul.f32 f569, f95, 0fBF3504F3;
mul.f32 f570, f96, 0f3F3504F3;
sub.f32 f103, f569, f570;
mul.f32 f104, f96, 0fBF3504F3;
fma.rn.f32 f105, f95, 0f3F3504F3, f104;
add.f32 f106, f73, f89;
sub.f32 f108, f73, f89;
add.f32 f568, f579, f572;
sub.f32 f109, f579, f572;
add.f32 f110, f77, f99;
sub.f32 f112, f77, f99;
add.f32 f567, f578, f100;
sub.f32 f113, f578, f100;
sub.f32 f114, f75, f92;
add.f32 f116, f75, f92;
add.f32 f566, f76, f91;
sub.f32 f117, f76, f91;
add.f32 f118, f79, f103;
sub.f32 f120, f79, f103;
add.f32 f565, f80, f105;
sub.f32 f121, f80, f105;
add.f32 f122, %36, %52;
sub.f32 f124, %36, %52;
add.f32 f563, %71, %53;
sub.f32 f125, %71, %53;
add.f32 f126, %44, %60;
sub.f32 f128, %44, %60;
add.f32 f560, %72, %73;
sub.f32 f129, %72, %73;
add.f32 f130, f122, f126;
sub.f32 f132, f122, f126;
add.f32 f559, f563, f560;
sub.f32 f133, f563, f560;
sub.f32 f134, f124, f129;
add.f32 f136, f124, f129;
add.f32 f558, f125, f128;
sub.f32 f137, f125, f128;
add.f32 f138, %40, %56;
sub.f32 f140, %40, %56;
add.f32 f556, %41, %74;
sub.f32 f141, %41, %74;
add.f32 f142, %48, %64;
sub.f32 f144, %48, %64;
add.f32 f554, %75, %65;
sub.f32 f145, %75, %65;
add.f32 f146, f138, f142;
sub.f32 f148, f138, f142;
add.f32 f553, f556, f554;
sub.f32 f149, f556, f554;
sub.f32 f150, f140, f145;
add.f32 f152, f140, f145;
add.f32 f552, f141, f144;
sub.f32 f153, f141, f144;
mul.f32 f154, f150, 0f3F3504F3;
mul.f32 f155, f552, 0f3F3504F3;
sub.f32 f156, f154, f155;
add.f32 f157, f154, f155;
mul.f32 f550, f152, 0fBF3504F3;
mul.f32 f551, f153, 0f3F3504F3;
sub.f32 f160, f550, f551;
mul.f32 f161, f153, 0fBF3504F3;
fma.rn.f32 f162, f152, 0f3F3504F3, f161;
add.f32 f163, f130, f146;
sub.f32 f165, f130, f146;
add.f32 f549, f559, f553;
sub.f32 f166, f559, f553;
add.f32 f167, f134, f156;
sub.f32 f169, f134, f156;
add.f32 f548, f558, f157;
sub.f32 f170, f558, f157;
sub.f32 f171, f132, f149;
add.f32 f173, f132, f149;
add.f32 f547, f133, f148;
sub.f32 f174, f133, f148;
add.f32 f175, f136, f160;
sub.f32 f177, f136, f160;
add.f32 f546, f137, f162;
sub.f32 f178, f137, f162;
mul.f32 f544, f167, 0f3F6C835E;
mul.f32 f545, f548, 0f3EC3EF15;
sub.f32 f181, f544, f545;
mul.f32 f182, f548, 0f3F6C835E;
fma.rn.f32 f183, f167, 0f3EC3EF15, f182;
mul.f32 f184, f171, 0f3F3504F3;
mul.f32 f185, f547, 0f3F3504F3;
sub.f32 f186, f184, f185;
add.f32 f187, f184, f185;
mul.f32 f189, f546, 0f3F6C835E;
mul.f32 f543, f175, 0f3EC3EF15;
sub.f32 f190, f543, f189;
mul.f32 f191, f546, 0f3EC3EF15;
fma.rn.f32 f192, f175, 0f3F6C835E, f191;
mul.f32 f194, f170, 0f3F6C835E;
mul.f32 f542, f169, 0fBEC3EF15;
sub.f32 f195, f542, f194;
mul.f32 f196, f170, 0fBEC3EF15;
fma.rn.f32 f197, f169, 0f3F6C835E, f196;
mul.f32 f540, f173, 0fBF3504F3;
mul.f32 f541, f174, 0f3F3504F3;
sub.f32 f200, f540, f541;
mul.f32 f201, f174, 0fBF3504F3;
fma.rn.f32 f202, f173, 0f3F3504F3, f201;
mul.f32 f538, f177, 0fBF6C835E;
mul.f32 f539, f178, 0f3EC3EF15;
sub.f32 f205, f538, f539;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0f3EC3EF15, f206;
add.f32 f210, f110, f181;
sub.f32 f212, f110, f181;
add.f32 f537, f567, f183;
sub.f32 f213, f567, f183;
add.f32 f214, f114, f186;
sub.f32 f216, f114, f186;
add.f32 f536, f566, f187;
sub.f32 f217, f566, f187;
add.f32 f218, f118, f190;
sub.f32 f220, f118, f190;
add.f32 f535, f565, f192;
sub.f32 f221, f565, f192;
sub.f32 f222, f108, f166;
add.f32 f224, f108, f166;
add.f32 f534, f109, f165;
sub.f32 f225, f109, f165;
add.f32 f226, f112, f195;
sub.f32 f228, f112, f195;
add.f32 f533, f113, f197;
sub.f32 f229, f113, f197;
add.f32 f230, f116, f200;
sub.f32 f232, f116, f200;
add.f32 f532, f117, f202;
sub.f32 f233, f117, f202;
add.f32 f234, f120, f205;
sub.f32 f236, f120, f205;
add.f32 f531, f121, f207;
sub.f32 f237, f121, f207;
mov.u32 r15, %tid.x;
shl.b32 r7, r15, 7;
and.b32 r8, r7, -256;
add.s32 r9, r4, r8;
and.b32 r14, r15, 1;
shl.b32 r10, r15, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 8;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f238, f239}, [rd5];
mul.f32 f242, f537, f239;
mul.f32 f244, f238, f537;
mul.f32 f246, f239, f239;
mul.f32 f530, f238, f238;
sub.f32 f247, f530, f246;
mul.f32 f248, f239, f238;
fma.rn.f32 f249, f239, f238, f248;
mul.f32 f250, f536, f249;
mul.f32 f252, f247, f536;
mul.f32 f528, f238, f247;
mul.f32 f529, f239, f249;
sub.f32 f255, f528, f529;
mul.f32 f527, f214, f249;
mul.f32 f256, f238, f249;
fma.rn.f32 f257, f239, f247, f256;
mul.f32 f258, f535, f257;
mul.f32 f260, f255, f535;
mul.f32 f262, f239, f257;
mul.f32 f526, f238, f255;
sub.f32 f263, f526, f262;
mul.f32 f525, f218, f257;
mul.f32 f264, f238, f257;
fma.rn.f32 f265, f239, f255, f264;
mul.f32 f266, f534, f265;
mul.f32 f268, f263, f534;
mul.f32 f270, f239, f265;
mul.f32 f524, f238, f263;
sub.f32 f271, f524, f270;
mul.f32 f523, f222, f265;
mul.f32 f272, f238, f265;
fma.rn.f32 f273, f239, f263, f272;
mul.f32 f274, f533, f273;
mul.f32 f276, f271, f533;
mul.f32 f521, f238, f271;
mul.f32 f522, f239, f273;
sub.f32 f279, f521, f522;
mul.f32 f520, f226, f273;
mul.f32 f280, f238, f273;
fma.rn.f32 f281, f239, f271, f280;
mul.f32 f282, f532, f281;
mul.f32 f284, f279, f532;
mul.f32 f286, f239, f281;
mul.f32 f519, f238, f279;
sub.f32 f287, f519, f286;
mul.f32 f518, f230, f281;
mul.f32 f288, f238, f281;
fma.rn.f32 f289, f239, f279, f288;
mul.f32 f290, f531, f289;
mul.f32 f292, f287, f531;
mul.f32 f294, f239, f289;
mul.f32 f517, f238, f287;
sub.f32 f295, f517, f294;
mul.f32 f516, f234, f289;
mul.f32 f296, f238, f289;
fma.rn.f32 f297, f239, f287, f296;
sub.f32 f515, f568, f549;
mul.f32 f298, f515, f297;
mul.f32 f300, f295, f515;
mul.f32 f513, f238, f295;
mul.f32 f514, f239, f297;
sub.f32 f303, f513, f514;
sub.f32 f512, f106, f163;
mul.f32 f511, f512, f297;
mul.f32 f304, f238, f297;
fma.rn.f32 f305, f239, f295, f304;
mul.f32 f306, f213, f305;
mul.f32 f308, f303, f213;
mul.f32 f310, f239, f305;
mul.f32 f510, f238, f303;
sub.f32 f311, f510, f310;
mul.f32 f509, f212, f305;
mul.f32 f312, f238, f305;
fma.rn.f32 f313, f239, f303, f312;
mul.f32 f314, f217, f313;
mul.f32 f316, f311, f217;
mul.f32 f507, f238, f311;
mul.f32 f508, f239, f313;
sub.f32 f319, f507, f508;
mul.f32 f506, f216, f313;
mul.f32 f320, f238, f313;
fma.rn.f32 f321, f239, f311, f320;
mul.f32 f322, f221, f321;
mul.f32 f324, f319, f221;
mul.f32 f326, f239, f321;
mul.f32 f505, f238, f319;
sub.f32 f327, f505, f326;
mul.f32 f504, f220, f321;
mul.f32 f328, f238, f321;
fma.rn.f32 f329, f239, f319, f328;
mul.f32 f330, f225, f329;
mul.f32 f332, f327, f225;
mul.f32 f334, f239, f329;
mul.f32 f503, f238, f327;
sub.f32 f335, f503, f334;
mul.f32 f502, f224, f329;
mul.f32 f336, f238, f329;
fma.rn.f32 f337, f239, f327, f336;
mul.f32 f338, f229, f337;
mul.f32 f340, f335, f229;
mul.f32 f500, f238, f335;
mul.f32 f501, f239, f337;
sub.f32 f343, f500, f501;
mul.f32 f499, f228, f337;
mul.f32 f344, f238, f337;
fma.rn.f32 f345, f239, f335, f344;
mul.f32 f346, f233, f345;
mul.f32 f348, f343, f233;
mul.f32 f350, f239, f345;
mul.f32 f498, f238, f343;
sub.f32 f351, f498, f350;
mul.f32 f497, f232, f345;
mul.f32 f352, f238, f345;
mul.f32 f496, f210, f239;
fma.rn.f32 f353, f239, f343, f352;
mul.f32 f354, f237, f353;
mul.f32 f355, f236, f353;
mul.f32 f356, f351, f237;
barrier.sync 0;
and.b32 r11, r7, 128;
add.s32 r12, r9, r11;
mov.u32 r17, %tid.x;
and.b32 r16, r17, 1;
sub.f32 f585, f568, f549;
mul.f32 f584, f295, f585;
add.f32 f357, f568, f549;
mov.u32 r19, %tid.x;
and.b32 r18, r19, 1;
sub.f32 f586, f106, f163;
add.f32 f358, f106, f163;
mov.u32 r21, %tid.x;
and.b32 r20, r21, 1;
mov.u32 r23, %tid.x;
and.b32 r22, r23, 1;
fma.rn.f32 f359, f238, f210, f242;
sub.f32 f360, f244, f496;
st.shared.v4.f32 [r12], {f358, f357, f359, f360};
fma.rn.f32 f361, f247, f214, f250;
sub.f32 f362, f252, f527;
fma.rn.f32 f363, f255, f218, f258;
sub.f32 f364, f260, f525;
st.shared.v4.f32 [r12+16], {f361, f362, f363, f364};
sub.f32 f365, f268, f523;
fma.rn.f32 f366, f263, f222, f266;
fma.rn.f32 f367, f271, f226, f274;
sub.f32 f368, f276, f520;
st.shared.v4.f32 [r12+32], {f366, f365, f367, f368};
fma.rn.f32 f369, f279, f230, f282;
sub.f32 f370, f284, f518;
fma.rn.f32 f371, f287, f234, f290;
sub.f32 f372, f292, f516;
st.shared.v4.f32 [r12+48], {f369, f370, f371, f372};
fma.rn.f32 f373, f295, f586, f298;
sub.f32 f374, f584, f511;
fma.rn.f32 f375, f303, f212, f306;
sub.f32 f376, f308, f509;
st.shared.v4.f32 [r12+64], {f373, f374, f375, f376};
fma.rn.f32 f377, f311, f216, f314;
sub.f32 f378, f316, f506;
fma.rn.f32 f379, f319, f220, f322;
sub.f32 f380, f324, f504;
st.shared.v4.f32 [r12+80], {f377, f378, f379, f380};
fma.rn.f32 f381, f327, f224, f330;
sub.f32 f382, f332, f502;
fma.rn.f32 f383, f335, f228, f338;
sub.f32 f384, f340, f499;
st.shared.v4.f32 [r12+96], {f381, f382, f383, f384};
fma.rn.f32 f385, f343, f232, f346;
sub.f32 f386, f348, f497;
fma.rn.f32 f387, f351, f236, f354;
sub.f32 f388, f356, f355;
st.shared.v4.f32 [r12+112], {f385, f386, f387, f388};
barrier.sync 0;
mad.lo.s32 r13, r22, -120, r12;
ld.shared.v2.f32 {f389, f390}, [r13];
ld.shared.v2.f32 {f393, f394}, [r13+16];
ld.shared.v2.f32 {f397, f398}, [r13+32];
ld.shared.v2.f32 {f401, f402}, [r13+48];
ld.shared.v2.f32 {f405, f406}, [r13+64];
ld.shared.v2.f32 {f409, f410}, [r13+80];
ld.shared.v2.f32 {f413, f414}, [r13+96];
ld.shared.v2.f32 {f417, f418}, [r13+112];
ld.shared.v2.f32 {f421, f422}, [r13+128];
ld.shared.v2.f32 {f425, f426}, [r13+144];
ld.shared.v2.f32 {f429, f430}, [r13+160];
ld.shared.v2.f32 {f433, f434}, [r13+176];
ld.shared.v2.f32 {f437, f438}, [r13+192];
ld.shared.v2.f32 {f441, f442}, [r13+208];
ld.shared.v2.f32 {f445, f446}, [r13+224];
ld.shared.v2.f32 {f449, f450}, [r13+240];
add.f32 %0, f389, f421;
add.f32 %1, f390, f422;
add.f32 %2, f393, f425;
add.f32 %3, f394, f426;
add.f32 %5, f398, f430;
add.f32 %4, f397, f429;
add.f32 %7, f402, f434;
add.f32 %6, f401, f433;
add.f32 %9, f406, f438;
add.f32 %8, f405, f437;
add.f32 %10, f409, f441;
add.f32 %11, f410, f442;
add.f32 %12, f413, f445;
add.f32 %13, f414, f446;
add.f32 %14, f417, f449;
add.f32 %15, f418, f450;
sub.f32 %17, f390, f422;
sub.f32 %16, f389, f421;
sub.f32 %19, f394, f426;
sub.f32 %18, f393, f425;
sub.f32 %21, f398, f430;
sub.f32 %20, f397, f429;
sub.f32 %23, f402, f434;
sub.f32 %22, f401, f433;
sub.f32 %25, f406, f438;
sub.f32 %24, f405, f437;
sub.f32 %27, f410, f442;
sub.f32 %26, f409, f441;
sub.f32 %29, f414, f446;
sub.f32 %28, f413, f445;
sub.f32 %31, f418, f450;
sub.f32 %30, f417, f449;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[8].y), "f"(rmem[4].y), "f"(rmem[10].y), "f"(rmem[2].y), "f"(rmem[14].y), "f"(rmem[1].y), "f"(rmem[5].y), "f"(rmem[13].y), "f"(rmem[11].y), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<241, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<81>;
.reg .b32 r<35>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f9, %9, %11;
add.f32 f10, %10, %12;
sub.f32 f11, %9, %11;
sub.f32 f12, %10, %12;
shl.b32 r6, r5, 3;
cvt.u64.u32 rd2, r6;
and.b64 rd3, rd2, 120;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f13, f14}, [rd5];
mul.f32 f17, f12, f14;
fma.rn.f32 f18, f13, f11, f17;
mul.f32 f19, f11, f14;
mul.f32 f20, f13, f12;
sub.f32 f21, f20, f19;
and.b32 r7, r6, -128;
add.s32 r8, r4, r7;
barrier.sync 0;
and.b32 r9, r6, 120;
add.s32 r10, r8, r9;
st.shared.v2.f32 [r10], {f9, f18};
barrier.sync 0;
shl.b32 r11, r5, 2;
and.b32 r12, r11, 60;
sub.s32 r13, r10, r12;
ld.shared.f32 f22, [r13];
ld.shared.f32 f23, [r13+64];
barrier.sync 0;
st.shared.v2.f32 [r10], {f10, f21};
barrier.sync 0;
ld.shared.f32 f24, [r13];
ld.shared.f32 f25, [r13+64];
add.f32 f26, f22, f23;
add.f32 f27, f24, f25;
sub.f32 f28, f22, f23;
sub.f32 f29, f24, f25;
bfe.u32 r14, r5, 1, 3;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f30, f31}, [rd8];
mul.f32 f34, f29, f31;
fma.rn.f32 f35, f30, f28, f34;
mul.f32 f36, f28, f31;
mul.f32 f37, f30, f29;
sub.f32 f38, f37, f36;
and.b32 r15, r11, 4;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 112;
add.s32 r18, r16, r17;
st.shared.f32 [r18], f26;
st.shared.f32 [r18+8], f35;
barrier.sync 0;
and.b32 r19, r11, 56;
sub.s32 r20, r18, r19;
ld.shared.f32 f39, [r20];
ld.shared.f32 f40, [r20+64];
barrier.sync 0;
st.shared.f32 [r18], f27;
st.shared.f32 [r18+8], f38;
barrier.sync 0;
ld.shared.f32 f41, [r20];
ld.shared.f32 f42, [r20+64];
add.f32 f43, f39, f40;
add.f32 f44, f41, f42;
sub.f32 f45, f39, f40;
sub.f32 f46, f41, f42;
bfe.u32 r21, r5, 2, 2;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f47, f48}, [rd11];
mul.f32 f51, f46, f48;
fma.rn.f32 f52, f47, f45, f51;
mul.f32 f53, f45, f48;
mul.f32 f54, f47, f46;
sub.f32 f55, f54, f53;
and.b32 r22, r11, 12;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 96;
add.s32 r25, r23, r24;
st.shared.f32 [r25], f43;
st.shared.f32 [r25+16], f52;
barrier.sync 0;
and.b32 r26, r11, 48;
sub.s32 r27, r25, r26;
ld.shared.f32 f56, [r27];
ld.shared.f32 f57, [r27+64];
barrier.sync 0;
st.shared.f32 [r25], f44;
st.shared.f32 [r25+16], f55;
barrier.sync 0;
ld.shared.f32 f58, [r27];
ld.shared.f32 f59, [r27+64];
add.f32 f60, f56, f57;
add.f32 f61, f58, f59;
sub.f32 f62, f56, f57;
sub.f32 f63, f58, f59;
and.b32 r28, r5, 8;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f64, f65}, [rd14];
mul.f32 f68, f63, f65;
fma.rn.f32 f69, f64, f62, f68;
mul.f32 f70, f62, f65;
mul.f32 f71, f64, f63;
sub.f32 f72, f71, f70;
and.b32 r29, r11, 28;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 64;
add.s32 r32, r30, r31;
st.shared.f32 [r32], f60;
st.shared.f32 [r32+32], f69;
barrier.sync 0;
and.b32 r33, r11, 32;
sub.s32 r34, r32, r33;
ld.shared.f32 f73, [r34];
ld.shared.f32 f74, [r34+64];
barrier.sync 0;
st.shared.f32 [r32], f61;
st.shared.f32 [r32+32], f72;
barrier.sync 0;
ld.shared.f32 f75, [r34];
ld.shared.f32 f76, [r34+64];
add.f32 %0, f73, f74;
add.f32 %1, f75, f76;
sub.f32 %2, f73, f74;
sub.f32 %3, f75, f76;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<242, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<453>;
.reg .b32 r<14>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f65, %34, %55;
add.f32 f66, %35, %57;
sub.f32 f67, %34, %55;
sub.f32 f68, %35, %57;
add.f32 f69, %44, %66;
add.f32 f70, %46, %67;
sub.f32 f71, %44, %66;
sub.f32 f72, %46, %67;
add.f32 f73, f65, f69;
add.f32 f74, f66, f70;
sub.f32 f75, f65, f69;
sub.f32 f76, f66, f70;
sub.f32 f77, f67, f72;
add.f32 f78, f68, f71;
add.f32 f79, f67, f72;
sub.f32 f80, f68, f71;
add.f32 f81, %39, %60;
add.f32 f82, %41, %62;
sub.f32 f83, %39, %60;
sub.f32 f84, %41, %62;
add.f32 f85, %50, %71;
add.f32 f86, %51, %73;
sub.f32 f87, %50, %71;
sub.f32 f88, %51, %73;
add.f32 f89, f81, f85;
add.f32 f90, f82, f86;
sub.f32 f91, f81, f85;
sub.f32 f92, f82, f86;
sub.f32 f93, f83, f88;
add.f32 f94, f84, f87;
add.f32 f95, f83, f88;
sub.f32 f96, f84, f87;
mul.f32 f97, f93, 0f3F3504F3;
mul.f32 f98, f94, 0f3F3504F3;
sub.f32 f99, f97, f98;
add.f32 f100, f97, f98;
mul.f32 f101, f95, 0fBF3504F3;
mul.f32 f102, f96, 0f3F3504F3;
sub.f32 f103, f101, f102;
mul.f32 f104, f96, 0fBF3504F3;
fma.rn.f32 f105, f95, 0f3F3504F3, f104;
add.f32 f106, f73, f89;
add.f32 f107, f74, f90;
sub.f32 f108, f73, f89;
sub.f32 f109, f74, f90;
add.f32 f110, f77, f99;
add.f32 f111, f78, f100;
sub.f32 f112, f77, f99;
sub.f32 f113, f78, f100;
sub.f32 f114, f75, f92;
add.f32 f115, f76, f91;
add.f32 f116, f75, f92;
sub.f32 f117, f76, f91;
add.f32 f118, f79, f103;
add.f32 f119, f80, f105;
sub.f32 f120, f79, f103;
sub.f32 f121, f80, f105;
add.f32 f122, %36, %58;
add.f32 f123, %38, %59;
sub.f32 f124, %36, %58;
sub.f32 f125, %38, %59;
add.f32 f126, %47, %68;
add.f32 f127, %49, %70;
sub.f32 f128, %47, %68;
sub.f32 f129, %49, %70;
add.f32 f130, f122, f126;
add.f32 f131, f123, f127;
sub.f32 f132, f122, f126;
sub.f32 f133, f123, f127;
sub.f32 f134, f124, f129;
add.f32 f135, f125, f128;
add.f32 f136, f124, f129;
sub.f32 f137, f125, f128;
add.f32 f138, %42, %63;
add.f32 f139, %43, %65;
sub.f32 f140, %42, %63;
sub.f32 f141, %43, %65;
add.f32 f142, %52, %74;
add.f32 f143, %54, %75;
sub.f32 f144, %52, %74;
sub.f32 f145, %54, %75;
add.f32 f146, f138, f142;
add.f32 f147, f139, f143;
sub.f32 f148, f138, f142;
sub.f32 f149, f139, f143;
sub.f32 f150, f140, f145;
add.f32 f151, f141, f144;
add.f32 f152, f140, f145;
sub.f32 f153, f141, f144;
mul.f32 f154, f150, 0f3F3504F3;
mul.f32 f155, f151, 0f3F3504F3;
sub.f32 f156, f154, f155;
add.f32 f157, f154, f155;
mul.f32 f158, f152, 0fBF3504F3;
mul.f32 f159, f153, 0f3F3504F3;
sub.f32 f160, f158, f159;
mul.f32 f161, f153, 0fBF3504F3;
fma.rn.f32 f162, f152, 0f3F3504F3, f161;
add.f32 f163, f130, f146;
add.f32 f164, f131, f147;
sub.f32 f165, f130, f146;
sub.f32 f166, f131, f147;
add.f32 f167, f134, f156;
add.f32 f168, f135, f157;
sub.f32 f169, f134, f156;
sub.f32 f170, f135, f157;
sub.f32 f171, f132, f149;
add.f32 f172, f133, f148;
add.f32 f173, f132, f149;
sub.f32 f174, f133, f148;
add.f32 f175, f136, f160;
add.f32 f176, f137, f162;
sub.f32 f177, f136, f160;
sub.f32 f178, f137, f162;
mul.f32 f179, f167, 0f3F6C835E;
mul.f32 f180, f168, 0f3EC3EF15;
sub.f32 f181, f179, f180;
mul.f32 f182, f168, 0f3F6C835E;
fma.rn.f32 f183, f167, 0f3EC3EF15, f182;
mul.f32 f184, f171, 0f3F3504F3;
mul.f32 f185, f172, 0f3F3504F3;
sub.f32 f186, f184, f185;
add.f32 f187, f184, f185;
mul.f32 f188, f175, 0f3EC3EF15;
mul.f32 f189, f176, 0f3F6C835E;
sub.f32 f190, f188, f189;
mul.f32 f191, f176, 0f3EC3EF15;
fma.rn.f32 f192, f175, 0f3F6C835E, f191;
mul.f32 f193, f169, 0fBEC3EF15;
mul.f32 f194, f170, 0f3F6C835E;
sub.f32 f195, f193, f194;
mul.f32 f196, f170, 0fBEC3EF15;
fma.rn.f32 f197, f169, 0f3F6C835E, f196;
mul.f32 f198, f173, 0fBF3504F3;
mul.f32 f199, f174, 0f3F3504F3;
sub.f32 f200, f198, f199;
mul.f32 f201, f174, 0fBF3504F3;
fma.rn.f32 f202, f173, 0f3F3504F3, f201;
mul.f32 f203, f177, 0fBF6C835E;
mul.f32 f204, f178, 0f3EC3EF15;
sub.f32 f205, f203, f204;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0f3EC3EF15, f206;
add.f32 f208, f106, f163;
add.f32 f209, f107, f164;
sub.f32 f210, f106, f163;
sub.f32 f211, f107, f164;
add.f32 f212, f110, f181;
add.f32 f213, f111, f183;
sub.f32 f214, f110, f181;
sub.f32 f215, f111, f183;
add.f32 f216, f114, f186;
add.f32 f217, f115, f187;
sub.f32 f218, f114, f186;
sub.f32 f219, f115, f187;
add.f32 f220, f118, f190;
add.f32 f221, f119, f192;
sub.f32 f222, f118, f190;
sub.f32 f223, f119, f192;
sub.f32 f224, f108, f166;
add.f32 f225, f109, f165;
add.f32 f226, f108, f166;
sub.f32 f227, f109, f165;
add.f32 f228, f112, f195;
add.f32 f229, f113, f197;
sub.f32 f230, f112, f195;
sub.f32 f231, f113, f197;
add.f32 f232, f116, f200;
add.f32 f233, f117, f202;
sub.f32 f234, f116, f200;
sub.f32 f235, f117, f202;
add.f32 f236, f120, f205;
add.f32 f237, f121, f207;
sub.f32 f238, f120, f205;
sub.f32 f239, f121, f207;
and.b32 r6, r5, 1;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 8;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f240, f241}, [rd5];
mul.f32 f244, f213, f241;
fma.rn.f32 f245, f240, f212, f244;
mul.f32 f246, f212, f241;
mul.f32 f247, f240, f213;
sub.f32 f248, f247, f246;
mul.f32 f249, f240, f240;
mul.f32 f250, f241, f241;
sub.f32 f251, f249, f250;
mul.f32 f252, f241, f240;
fma.rn.f32 f253, f241, f240, f252;
mul.f32 f254, f217, f253;
fma.rn.f32 f255, f251, f216, f254;
mul.f32 f256, f216, f253;
mul.f32 f257, f251, f217;
sub.f32 f258, f257, f256;
mul.f32 f259, f240, f251;
mul.f32 f260, f241, f253;
sub.f32 f261, f259, f260;
mul.f32 f262, f240, f253;
fma.rn.f32 f263, f241, f251, f262;
mul.f32 f264, f221, f263;
fma.rn.f32 f265, f261, f220, f264;
mul.f32 f266, f220, f263;
mul.f32 f267, f261, f221;
sub.f32 f268, f267, f266;
mul.f32 f269, f240, f261;
mul.f32 f270, f241, f263;
sub.f32 f271, f269, f270;
mul.f32 f272, f240, f263;
fma.rn.f32 f273, f241, f261, f272;
mul.f32 f274, f225, f273;
fma.rn.f32 f275, f271, f224, f274;
mul.f32 f276, f224, f273;
mul.f32 f277, f271, f225;
sub.f32 f278, f277, f276;
mul.f32 f279, f240, f271;
mul.f32 f280, f241, f273;
sub.f32 f281, f279, f280;
mul.f32 f282, f240, f273;
fma.rn.f32 f283, f241, f271, f282;
mul.f32 f284, f229, f283;
fma.rn.f32 f285, f281, f228, f284;
mul.f32 f286, f228, f283;
mul.f32 f287, f281, f229;
sub.f32 f288, f287, f286;
mul.f32 f289, f240, f281;
mul.f32 f290, f241, f283;
sub.f32 f291, f289, f290;
mul.f32 f292, f240, f283;
fma.rn.f32 f293, f241, f281, f292;
mul.f32 f294, f233, f293;
fma.rn.f32 f295, f291, f232, f294;
mul.f32 f296, f232, f293;
mul.f32 f297, f291, f233;
sub.f32 f298, f297, f296;
mul.f32 f299, f240, f291;
mul.f32 f300, f241, f293;
sub.f32 f301, f299, f300;
mul.f32 f302, f240, f293;
fma.rn.f32 f303, f241, f291, f302;
mul.f32 f304, f237, f303;
fma.rn.f32 f305, f301, f236, f304;
mul.f32 f306, f236, f303;
mul.f32 f307, f301, f237;
sub.f32 f308, f307, f306;
mul.f32 f309, f240, f301;
mul.f32 f310, f241, f303;
sub.f32 f311, f309, f310;
mul.f32 f312, f240, f303;
fma.rn.f32 f313, f241, f301, f312;
mul.f32 f314, f211, f313;
fma.rn.f32 f315, f311, f210, f314;
mul.f32 f316, f210, f313;
mul.f32 f317, f311, f211;
sub.f32 f318, f317, f316;
mul.f32 f319, f240, f311;
mul.f32 f320, f241, f313;
sub.f32 f321, f319, f320;
mul.f32 f322, f240, f313;
fma.rn.f32 f323, f241, f311, f322;
mul.f32 f324, f215, f323;
fma.rn.f32 f325, f321, f214, f324;
mul.f32 f326, f214, f323;
mul.f32 f327, f321, f215;
sub.f32 f328, f327, f326;
mul.f32 f329, f240, f321;
mul.f32 f330, f241, f323;
sub.f32 f331, f329, f330;
mul.f32 f332, f240, f323;
fma.rn.f32 f333, f241, f321, f332;
mul.f32 f334, f219, f333;
fma.rn.f32 f335, f331, f218, f334;
mul.f32 f336, f218, f333;
mul.f32 f337, f331, f219;
sub.f32 f338, f337, f336;
mul.f32 f339, f240, f331;
mul.f32 f340, f241, f333;
sub.f32 f341, f339, f340;
mul.f32 f342, f240, f333;
fma.rn.f32 f343, f241, f331, f342;
mul.f32 f344, f223, f343;
fma.rn.f32 f345, f341, f222, f344;
mul.f32 f346, f222, f343;
mul.f32 f347, f341, f223;
sub.f32 f348, f347, f346;
mul.f32 f349, f240, f341;
mul.f32 f350, f241, f343;
sub.f32 f351, f349, f350;
mul.f32 f352, f240, f343;
fma.rn.f32 f353, f241, f341, f352;
mul.f32 f354, f227, f353;
fma.rn.f32 f355, f351, f226, f354;
mul.f32 f356, f226, f353;
mul.f32 f357, f351, f227;
sub.f32 f358, f357, f356;
mul.f32 f359, f240, f351;
mul.f32 f360, f241, f353;
sub.f32 f361, f359, f360;
mul.f32 f362, f240, f353;
fma.rn.f32 f363, f241, f351, f362;
mul.f32 f364, f231, f363;
fma.rn.f32 f365, f361, f230, f364;
mul.f32 f366, f230, f363;
mul.f32 f367, f361, f231;
sub.f32 f368, f367, f366;
mul.f32 f369, f240, f361;
mul.f32 f370, f241, f363;
sub.f32 f371, f369, f370;
mul.f32 f372, f240, f363;
fma.rn.f32 f373, f241, f361, f372;
mul.f32 f374, f235, f373;
fma.rn.f32 f375, f371, f234, f374;
mul.f32 f376, f234, f373;
mul.f32 f377, f371, f235;
sub.f32 f378, f377, f376;
mul.f32 f379, f240, f371;
mul.f32 f380, f241, f373;
sub.f32 f381, f379, f380;
mul.f32 f382, f240, f373;
fma.rn.f32 f383, f241, f371, f382;
mul.f32 f384, f239, f383;
fma.rn.f32 f385, f381, f238, f384;
mul.f32 f386, f238, f383;
mul.f32 f387, f381, f239;
sub.f32 f388, f387, f386;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -128;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 64;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f208, f245, f255, f265};
st.shared.v4.f32 [r12+16], {f275, f285, f295, f305};
st.shared.v4.f32 [r12+32], {f315, f325, f335, f345};
st.shared.v4.f32 [r12+48], {f355, f365, f375, f385};
barrier.sync 0;
mad.lo.s32 r13, r6, -60, r12;
ld.shared.f32 f389, [r13];
ld.shared.f32 f390, [r13+8];
ld.shared.f32 f391, [r13+16];
ld.shared.f32 f392, [r13+24];
ld.shared.f32 f393, [r13+32];
ld.shared.f32 f394, [r13+40];
ld.shared.f32 f395, [r13+48];
ld.shared.f32 f396, [r13+56];
ld.shared.f32 f397, [r13+64];
ld.shared.f32 f398, [r13+72];
ld.shared.f32 f399, [r13+80];
ld.shared.f32 f400, [r13+88];
ld.shared.f32 f401, [r13+96];
ld.shared.f32 f402, [r13+104];
ld.shared.f32 f403, [r13+112];
ld.shared.f32 f404, [r13+120];
barrier.sync 0;
st.shared.v4.f32 [r12], {f209, f248, f258, f268};
st.shared.v4.f32 [r12+16], {f278, f288, f298, f308};
st.shared.v4.f32 [r12+32], {f318, f328, f338, f348};
st.shared.v4.f32 [r12+48], {f358, f368, f378, f388};
barrier.sync 0;
ld.shared.f32 f405, [r13];
ld.shared.f32 f406, [r13+8];
ld.shared.f32 f407, [r13+16];
ld.shared.f32 f408, [r13+24];
ld.shared.f32 f409, [r13+32];
ld.shared.f32 f410, [r13+40];
ld.shared.f32 f411, [r13+48];
ld.shared.f32 f412, [r13+56];
ld.shared.f32 f413, [r13+64];
ld.shared.f32 f414, [r13+72];
ld.shared.f32 f415, [r13+80];
ld.shared.f32 f416, [r13+88];
ld.shared.f32 f417, [r13+96];
ld.shared.f32 f418, [r13+104];
ld.shared.f32 f419, [r13+112];
ld.shared.f32 f420, [r13+120];
add.f32 %0, f389, f397;
add.f32 %1, f405, f413;
add.f32 %2, f390, f398;
add.f32 %3, f406, f414;
add.f32 %4, f391, f399;
add.f32 %5, f407, f415;
add.f32 %6, f392, f400;
add.f32 %7, f408, f416;
add.f32 %8, f393, f401;
add.f32 %9, f409, f417;
add.f32 %10, f394, f402;
add.f32 %11, f410, f418;
add.f32 %12, f395, f403;
add.f32 %13, f411, f419;
add.f32 %14, f396, f404;
add.f32 %15, f412, f420;
sub.f32 %16, f389, f397;
sub.f32 %17, f405, f413;
sub.f32 %18, f390, f398;
sub.f32 %19, f406, f414;
sub.f32 %20, f391, f399;
sub.f32 %21, f407, f415;
sub.f32 %22, f392, f400;
sub.f32 %23, f408, f416;
sub.f32 %24, f393, f401;
sub.f32 %25, f409, f417;
sub.f32 %26, f394, f402;
sub.f32 %27, f410, f418;
sub.f32 %28, f395, f403;
sub.f32 %29, f411, f419;
sub.f32 %30, f396, f404;
sub.f32 %31, f412, f420;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y));
};


#endif
